#define PLUA_API_VERSION	0x0101

// This is the Lua/Plua API available to libraries.
// The only way for a library to access Plua internals is by using
// these functions.

typedef struct {
  unsigned short version;

  // Plua extensions

  void (*plua_setlibdata)(char *name, void *data);
  void *(*plua_getlibdata)(char *name);
  int (*plua_pusherror)(lua_State *L, int err);

  // basic stack manipulation

  int (*lua_gettop)(lua_State *L);
  void (*lua_settop)(lua_State *L, int index);
  void (*lua_pushvalue)(lua_State *L, int index);
  void (*lua_remove)(lua_State *L, int index);
  void (*lua_insert)(lua_State *L, int index);
  int (*lua_stackspace)(lua_State *L);

  // access functions (stack -> C)

  int (*lua_type)(lua_State *L, int index);
  const char *(*lua_typename)(lua_State *L, int t);
  int (*lua_isnumber)(lua_State *L, int index);
  int (*lua_isstring)(lua_State *L, int index);
  int (*lua_iscfunction)(lua_State *L, int index);
  int (*lua_tag)(lua_State *L, int index);
  int (*lua_equal)(lua_State *L, int index1, int index2);
  int (*lua_lessthan)(lua_State *L, int index1, int index2);
  Number (*lua_tonumber)(lua_State *L, int index);
  const char *(*lua_tostring)(lua_State *L, int index);
  size_t (*lua_strlen)(lua_State *L, int index);
  lua_CFunction (*lua_tocfunction)(lua_State *L, int index);
  void *(*lua_touserdata)(lua_State *L, int index);
  const void *(*lua_topointer)(lua_State *L, int index);

  // push functions (C -> stack)

  void (*lua_pushnil)(lua_State *L);
  void (*lua_pushnumber)(lua_State *L, Number n);
  void (*lua_pushlstring)(lua_State *L, const char *s, size_t len);
  void (*lua_pushstring)(lua_State *L, const char *s);
  void (*lua_pushcclosure)(lua_State *L, lua_CFunction fn, int n);
  void (*lua_pushusertag)(lua_State *L, void *u, int tag);

  // get functions (Lua -> stack)

  void (*lua_getglobal)(lua_State *L, const char *name);
  void (*lua_gettable)(lua_State *L, int index);
  void (*lua_rawget)(lua_State *L, int index);
  void (*lua_rawgeti)(lua_State *L, int index, int n);
  void (*lua_getglobals)(lua_State *L);
  void (*lua_gettagmethod)(lua_State *L, int tag, const char *event);
  int  (*lua_getref)(lua_State *L, int ref);
  void (*lua_newtable)(lua_State *L);

  // set functions (stack -> Lua)

  void (*lua_setglobal)(lua_State *L, const char *name);
  void (*lua_settable)(lua_State *L, int index);
  void (*lua_rawset)(lua_State *L, int index);
  void (*lua_rawseti)(lua_State *L, int index, int n);
  void (*lua_setglobals)(lua_State *L);
  void (*lua_settagmethod)(lua_State *L, int tag, const char *event);
  int  (*lua_ref)(lua_State *L, int lock);

  // "do" functions (run Lua code)

  int  (*lua_call)(lua_State *L, int nargs, int nresults);
  void (*lua_rawcall)(lua_State *L, int nargs, int nresults);
  int  (*lua_dofile)(lua_State *L, const char *filename);
  int  (*lua_dostring)(lua_State *L, const char *str);
  int  (*lua_dobuffer)(lua_State *L, const char *buff, size_t size, const char *name);

  // miscellaneous functions

  int  (*lua_newtag)(lua_State *L);
  int  (*lua_copytagmethods)(lua_State *L, int tagto, int tagfrom);
  void (*lua_settag)(lua_State *L, int tag);
  void (*lua_error)(lua_State *L, const char *s);
  void (*lua_errorx)(lua_State *L, const char *s, int errcode);
  void (*lua_unref)(lua_State *L, int ref);
  int  (*lua_next)(lua_State *L, int index);
  int  (*lua_getn)(lua_State *L, int index);
  void (*lua_concat)(lua_State *L, int n);
  void *(*lua_newuserdata)(lua_State *L, size_t size);

  // auxiliary funtions (lauxlib)

  void (*luaL_argerror)(lua_State *L, int numarg, const char *extramsg);
  const char *(*luaL_check_lstr)(lua_State *L, int numArg, size_t *len);
  const char *(*luaL_opt_lstr)(lua_State *L, int numArg, const char *def, size_t *len);
  Number (*luaL_check_number)(lua_State *L, int numArg);
  Number (*luaL_opt_number)(lua_State *L, int numArg, Number def);
  void (*luaL_checkstack)(lua_State *L, int space, const char *msg);
  void (*luaL_checktype)(lua_State *L, int narg, int t);
  void (*luaL_checkany)(lua_State *L, int narg);

  // libc funtions

  FILE *(*fopen)(const char *, const char *);
  int (*fclose)(FILE *);
  int (*feof)(FILE *);
  int (*fseek)(FILE *, long, int);
  long (*ftell)(FILE *);
  size_t (*fread)(void *, size_t, size_t, FILE *);
  size_t (*fwrite)(void *, size_t, size_t, FILE *);
  int (*fputs)(const char *, FILE *);
  char *(*fgets)(char *, int, FILE *);

} PluaAPI;
